XIncludeFile "brushes.pbi"

Procedure New_brush()
  If OpenWindow(#Window_new_brush, 0, 0, #Window_new_brush_w, #Window_new_brush_h, "New brush", #PB_Window_WindowCentered | #PB_Window_TitleBar, WindowID(#Window))
    Protected selected_brush.l = GetGadgetState(#BrushesListIcon)
    TextGadget(#NameText, #NameText_x, #NameText_y, #NameText_w, #NameText_h, "Name :")
    StringGadget(#NameString, #NameString_x, #NameString_y, #NameString_w, #NameString_h, "")
    TextGadget(#TileText, #TileText_x, #TileText_y, #TileText_w, #TileText_h, "Tile :")
    ComboBoxGadget(#ComboBox, #ComboBox_x, #ComboBox_y, #ComboBox_w, #ComboBox_h, #PB_ComboBox_Image)
    ForEach tiles()
      AddGadgetItem(#ComboBox, -1, tiles(), ImageID(LoadImage(#PB_Any, "tiles"+#Path_separator+tiles())))
    Next
    TextGadget(#InteractionText, #InteractionText_x, #InteractionText_y, #InteractionText_w, #InteractionText_h, "I")
    TextGadget(#CollisionText, #CollisionText_x, #CollisionText_y, #CollisionText_w, #CollisionText_h, "C")
    TextGadget(#TileTopText, #TileTopText_x, #TileTopText_y, #TileTopText_w, #TileTopText_h, "T")
    TextGadget(#NotPassableText, #NotPassableText_x, #NotPassableText_y, #NotPassableText_w, #NotPassableText_h, "N")
    TextGadget(#AnimatedText, #AnimatedText_x, #AnimatedText_y, #AnimatedText_w, #AnimatedText_h, "A")
    TextGadget(#ByteParameterText, #ByteParameterText_x, #ByteParameterText_y, #ByteParameterText_w, #ByteParameterText_h, ".db %")
    CheckBoxGadget(#InteractionCheckBox, #InteractionCheckBox_x, #InteractionCheckBox_y, #InteractionCheckBox_w, #InteractionCheckBox_h, "")
    GadgetToolTip(#InteractionCheckBox, "Interaction")
    CheckBoxGadget(#CollisionCheckBox, #CollisionCheckBox_x, #CollisionCheckBox_y, #CollisionCheckBox_w, #CollisionCheckBox_h, "")
    GadgetToolTip(#CollisionCheckBox, "Collision")
    CheckBoxGadget(#UnusedBit5CheckBox, #UnusedBit5CheckBox_x, #UnusedBit5CheckBox_y, #UnusedBit5CheckBox_w, #UnusedBit5CheckBox_h, "")
    GadgetToolTip(#UnusedBit5CheckBox, "Unused bit #5")
    DisableGadget(#UnusedBit5CheckBox, 1)
    CheckBoxGadget(#UnusedBit4CheckBox, #UnusedBit4CheckBox_x, #UnusedBit4CheckBox_y, #UnusedBit4CheckBox_w, #UnusedBit4CheckBox_h, "")
    GadgetToolTip(#UnusedBit4CheckBox, "Unused bit #4")
    DisableGadget(#UnusedBit4CheckBox, 1)
    CheckBoxGadget(#UnusedBit3CheckBox, #UnusedBit3CheckBox_x, #UnusedBit3CheckBox_y, #UnusedBit3CheckBox_w, #UnusedBit3CheckBox_h, "")
    GadgetToolTip(#UnusedBit3CheckBox, "Unused bit #3")
    DisableGadget(#UnusedBit3CheckBox, 1)
    CheckBoxGadget(#TileTopCheckBox, #TileTopCheckBox_x, #TileTopCheckBox_y, #TileTopCheckBox_w, #TileTopCheckBox_h, "")
    GadgetToolTip(#TileTopCheckBox, "Tile top")
    CheckBoxGadget(#NotPassableCheckBox, #NotPassableCheckBox_x, #NotPassableCheckBox_y, #NotPassableCheckBox_w, #NotPassableCheckBox_h, "")
    GadgetToolTip(#NotPassableCheckBox, "Not passable")
    CheckBoxGadget(#AnimatedCheckBox, #AnimatedCheckBox_x, #AnimatedCheckBox_y, #AnimatedCheckBox_w, #AnimatedCheckBox_h, "")
    GadgetToolTip(#AnimatedCheckBox, "Animated")
    TextGadget(#OffsetText, #OffsetText_x, #OffsetText_y, #OffsetText_w, #OffsetText_h, "Animation offset #")
    SpinGadget(#OffsetSpin, #OffsetSpin_x, #OffsetSpin_y, #OffsetSpin_w, #OffsetSpin_h, 0, 255, #PB_Spin_Numeric)
    SetGadgetState(#OffsetSpin, 0)
    DisableGadget(#OffsetSpin, 1)
    TextGadget(#TileTopText2, #TileTopText2_x, #TileTopText2_y, #TileTopText2_w, #TileTopText2_h, "Tile top =")
    SpinGadget(#TileTopSpin, #TileTopSpin_x, #TileTopSpin_y, #TileTopSpin_w, #TileTopSpin_h, 0, #TILE_HEIGHT, #PB_Spin_Numeric)
    SetGadgetState(#TileTopSpin, 0)
    DisableGadget(#TileTopSpin, 1)
    TextGadget(#MaskText, #MaskText_x, #MaskText_y, #MaskText_w, #MaskText_h, "Mask :")
    ComboBoxGadget(#ComboBox2, #ComboBox2_x, #ComboBox2_y, #ComboBox2_w, #ComboBox2_h, #PB_ComboBox_Image)
    ForEach masks()
      AddGadgetItem(#ComboBox2, -1, masks(), ImageID(LoadImage(#PB_Any, "masks"+#Path_separator+masks())))
    Next
    DisableGadget(#ComboBox2, 1)
    Frame3DGadget(#CollisionFrame3D, #CollisionFrame3D_x, #CollisionFrame3D_y, #CollisionFrame3D_w, #CollisionFrame3D_h, "Collision")
    EditorGadget(#CollisionEditor, #CollisionEditor_x, #CollisionEditor_y, #CollisionEditor_w, #CollisionEditor_h)
    GadgetToolTip(#CollisionEditor, "Collisions :"+Chr(10)+"0=text"+Chr(10)+Chr(9)+".db 0"+Chr(10)+Chr(9)+".dw text"+Chr(10)+"1=change map"+Chr(10)+Chr(9)+".db 1"+Chr(10)+Chr(9)+".db x,y,mapid")
    DisableGadget(#CollisionEditor, 1)
    Frame3DGadget(#InteractionFrame3D, #InteractionFrame3D_x, #InteractionFrame3D_y, #InteractionFrame3D_w, #InteractionFrame3D_h, "Interaction")
    EditorGadget(#InteractionEditor, #InteractionEditor_x, #InteractionEditor_y, #InteractionEditor_w, #InteractionEditor_h)
    GadgetToolTip(#InteractionEditor, "Interactions :"+Chr(10)+"0=text"+Chr(10)+Chr(9)+".db 0"+Chr(10)+Chr(9)+".dw text"+Chr(10)+"1=change map"+Chr(10)+Chr(9)+".db 1"+Chr(10)+Chr(9)+".db x,y,mapid")
    DisableGadget(#InteractionEditor, 1)
    ButtonGadget(#OKButton4, #OKButton4_x, #OKButton4_y, #OKButton4_w, #OKButton4_h, "Ok")
    ButtonGadget(#CancelButton4, #CancelButton4_x, #CancelButton4_y, #CancelButton4_w, #CancelButton4_h, "Cancel")

    Protected ok.l = 0, quit.l = 0
    DisableWindow(#Window, 1)
    DisableGadget(#OKButton4, 1)
    Repeat
      Select WaitWindowEvent()
        Case #PB_Event_Gadget
          Select EventGadget()
            Case #NameString
              If GetGadgetState(#ComboBox) <> -1 And GetGadgetText(#NameString) <> ""
                DisableGadget(#OKButton4, 0)
              Else
                DisableGadget(#OKButton4, 1)
              EndIf
            Case #ComboBox
              If GetGadgetState(#ComboBox) <> -1 And GetGadgetText(#NameString) <> ""
                DisableGadget(#OKButton4, 0)
              Else
                DisableGadget(#OKButton4, 1)
              EndIf
            Case #InteractionCheckBox
              If GetGadgetState(#InteractionCheckBox) = #PB_Checkbox_Checked
                DisableGadget(#InteractionEditor, 0)
              Else
                DisableGadget(#InteractionEditor, 1)
              EndIf
            Case #CollisionCheckBox
              If GetGadgetState(#CollisionCheckBox) = #PB_Checkbox_Checked
                DisableGadget(#CollisionEditor, 0)
              Else
                DisableGadget(#CollisionEditor, 1)
              EndIf
            Case #TileTopCheckBox
              If GetGadgetState(#TileTopCheckBox) = #PB_Checkbox_Checked
                DisableGadget(#TileTopSpin, 0)
                DisableGadget(#ComboBox2, 0)
              Else
                DisableGadget(#TileTopSpin, 1)
                DisableGadget(#ComboBox2, 1)
              EndIf
            Case #AnimatedCheckBox
              If GetGadgetState(#AnimatedCheckBox) = #PB_Checkbox_Checked
                DisableGadget(#OffsetSpin, 0)
              Else
                DisableGadget(#OffsetSpin, 1)
              EndIf
            Case #OKButton4
              ok = 1
              quit = 1
            Case #CancelButton4
              ok = 0
              quit = 1
          EndSelect
        Default
          Delay(10)
      EndSelect
    Until quit
    If ok
      AddMapElement(brushes(), Str(MapSize(brushes())))
      brushes()\name = GetGadgetText(#NameString)
      brushes()\tile = GetGadgetState(#ComboBox)
      brushes()\animated = GetGadgetState(#AnimatedCheckBox)
      brushes()\offset = GetGadgetState(#OffsetSpin)
      brushes()\notpassable = GetGadgetState(#NotPassableCheckBox)
      If GetGadgetState(#TileTopCheckBox) = #PB_Checkbox_Checked
        brushes()\height = GetGadgetState(#TileTopSpin)
        brushes()\mask = GetGadgetState(#ComboBox2)
      Else
        brushes()\height = 0
        brushes()\mask = 0
      EndIf
      If GetGadgetState(#CollisionCheckBox) = #PB_Checkbox_Checked
        brushes()\collision = ReplaceString(GetGadgetText(#CollisionEditor), Chr(13)+Chr(10), " | ", #PB_String_CaseSensitive)
      Else
        brushes()\collision = ""
      EndIf
      If GetGadgetState(#InteractionCheckBox) = #PB_Checkbox_Checked
        brushes()\interaction = ReplaceString(GetGadgetText(#InteractionEditor), Chr(13)+Chr(10), " | ", #PB_String_CaseSensitive)
      Else
        brushes()\interaction = ""
      EndIf
      RefreshBrushes()
      SaveBrushes()
      HandleMap()
    EndIf
    SetGadgetState(#BrushesListIcon, selected_brush)
    CloseWindow(#Window_new_brush)
    DisableWindow(#Window, 0)
    SetActiveWindow(#Window)
  EndIf
EndProcedure

Procedure Edit_brush(id.l)
  If OpenWindow(#Window_new_brush, 0, 0, #Window_new_brush_w, #Window_new_brush_h, "Edit brush", #PB_Window_WindowCentered | #PB_Window_TitleBar, WindowID(#Window))
    Protected selected_brush.l = GetGadgetState(#BrushesListIcon)
    TextGadget(#NameText, #NameText_x, #NameText_y, #NameText_w, #NameText_h, "Name :")
    StringGadget(#NameString, #NameString_x, #NameString_y, #NameString_w, #NameString_h, brushes(Str(id))\name)
    TextGadget(#TileText, #TileText_x, #TileText_y, #TileText_w, #TileText_h, "Tile : ")
    ComboBoxGadget(#ComboBox, #ComboBox_x, #ComboBox_y, #ComboBox_w, #ComboBox_h, #PB_ComboBox_Image)
    ForEach tiles()
      AddGadgetItem(#ComboBox, -1, tiles(), ImageID(LoadImage(#PB_Any, "tiles"+#Path_separator+tiles())))
    Next
    SetGadgetState(#ComboBox, brushes(Str(id))\tile)
    TextGadget(#InteractionText, #InteractionText_x, #InteractionText_y, #InteractionText_w, #InteractionText_h, "I")
    TextGadget(#CollisionText, #CollisionText_x, #CollisionText_y, #CollisionText_w, #CollisionText_h, "C")
    TextGadget(#TileTopText, #TileTopText_x, #TileTopText_y, #TileTopText_w, #TileTopText_h, "T")
    TextGadget(#NotPassableText, #NotPassableText_x, #NotPassableText_y, #NotPassableText_w, #NotPassableText_h, "N")
    TextGadget(#AnimatedText, #AnimatedText_x, #AnimatedText_y, #AnimatedText_w, #AnimatedText_h, "A")
    TextGadget(#ByteParameterText, #ByteParameterText_x, #ByteParameterText_y, #ByteParameterText_w, #ByteParameterText_h, ".db %")
    CheckBoxGadget(#InteractionCheckBox, #InteractionCheckBox_x, #InteractionCheckBox_y, #InteractionCheckBox_w, #InteractionCheckBox_h, "")
    GadgetToolTip(#InteractionCheckBox, "Interaction")
    If brushes(Str(id))\interaction <> ""
      SetGadgetState(#InteractionCheckBox, #PB_Checkbox_Checked)
    EndIf
    CheckBoxGadget(#CollisionCheckBox, #CollisionCheckBox_x, #CollisionCheckBox_y, #CollisionCheckBox_w, #CollisionCheckBox_h, "")
    GadgetToolTip(#CollisionCheckBox, "Collision")
    If brushes(Str(id))\collision <> ""
      SetGadgetState(#CollisionCheckBox, #PB_Checkbox_Checked)
    EndIf
    CheckBoxGadget(#UnusedBit5CheckBox, #UnusedBit5CheckBox_x, #UnusedBit5CheckBox_y, #UnusedBit5CheckBox_w, #UnusedBit5CheckBox_h, "")
    GadgetToolTip(#UnusedBit5CheckBox, "Unused bit #5")
    DisableGadget(#UnusedBit5CheckBox, 1)
    CheckBoxGadget(#UnusedBit4CheckBox, #UnusedBit4CheckBox_x, #UnusedBit4CheckBox_y, #UnusedBit4CheckBox_w, #UnusedBit4CheckBox_h, "")
    GadgetToolTip(#UnusedBit4CheckBox, "Unused bit #4")
    DisableGadget(#UnusedBit4CheckBox, 1)
    CheckBoxGadget(#UnusedBit3CheckBox, #UnusedBit3CheckBox_x, #UnusedBit3CheckBox_y, #UnusedBit3CheckBox_w, #UnusedBit3CheckBox_h, "")
    GadgetToolTip(#UnusedBit3CheckBox, "Unused bit #3")
    DisableGadget(#UnusedBit3CheckBox, 1)
    CheckBoxGadget(#TileTopCheckBox, #TileTopCheckBox_x, #TileTopCheckBox_y, #TileTopCheckBox_w, #TileTopCheckBox_h, "")
    GadgetToolTip(#TileTopCheckBox, "Tile top")
    If brushes(Str(id))\height > 0 Or brushes(Str(id))\mask > 0
      SetGadgetState(#TileTopCheckBox, #PB_Checkbox_Checked)
    EndIf
    CheckBoxGadget(#NotPassableCheckBox, #NotPassableCheckBox_x, #NotPassableCheckBox_y, #NotPassableCheckBox_w, #NotPassableCheckBox_h, "")
    GadgetToolTip(#NotPassableCheckBox, "Not passable")
    SetGadgetState(#NotPassableCheckBox, brushes(Str(id))\notpassable)
    CheckBoxGadget(#AnimatedCheckBox, #AnimatedCheckBox_x, #AnimatedCheckBox_y, #AnimatedCheckBox_w, #AnimatedCheckBox_h, "")
    GadgetToolTip(#AnimatedCheckBox, "Animated")
    SetGadgetState(#AnimatedCheckBox, brushes(Str(id))\animated)
    TextGadget(#OffsetText, #OffsetText_x, #OffsetText_y, #OffsetText_w, #OffsetText_h, "Animation offset #")
    SpinGadget(#OffsetSpin, #OffsetSpin_x, #OffsetSpin_y, #OffsetSpin_w, #OffsetSpin_h, 0, 255, #PB_Spin_Numeric)
    If brushes(Str(id))\animated
      SetGadgetState(#OffsetSpin, brushes(Str(id))\offset)
    Else
      SetGadgetState(#OffsetSpin, 0)
      DisableGadget(#OffsetSpin, 1)
    EndIf
    TextGadget(#TileTopText2, #TileTopText2_x, #TileTopText2_y, #TileTopText2_w, #TileTopText2_h, "Tile top =")
    SpinGadget(#TileTopSpin, #TileTopSpin_x, #TileTopSpin_y, #TileTopSpin_w, #TileTopSpin_h, 0, #TILE_HEIGHT, #PB_Spin_Numeric)
    If brushes(Str(id))\height > 0 Or brushes(Str(id))\mask > 0
      SetGadgetState(#TileTopSpin, brushes(Str(id))\height)
    Else
      SetGadgetState(#TileTopSpin, 0)
      DisableGadget(#TileTopSpin, 1)
    EndIf
    TextGadget(#MaskText, #MaskText_x, #MaskText_y, #MaskText_w, #MaskText_h, "Mask :")
    ComboBoxGadget(#ComboBox2, #ComboBox2_x, #ComboBox2_y, #ComboBox2_w, #ComboBox2_h, #PB_ComboBox_Image)
    ForEach masks()
      AddGadgetItem(#ComboBox2, -1, masks(), ImageID(LoadImage(#PB_Any, "masks"+#Path_separator+masks())))
    Next
    If brushes(Str(id))\height > 0 Or brushes(Str(id))\mask > 0
      SetGadgetState(#ComboBox2, brushes(Str(id))\mask)
    Else
      DisableGadget(#ComboBox2, 1)
    EndIf
    Frame3DGadget(#CollisionFrame3D, #CollisionFrame3D_x, #CollisionFrame3D_y, #CollisionFrame3D_w, #CollisionFrame3D_h, "Collision")
    EditorGadget(#CollisionEditor, #CollisionEditor_x, #CollisionEditor_y, #CollisionEditor_w, #CollisionEditor_h)
    If brushes(Str(id))\collision <> ""
      SetGadgetText(#CollisionEditor, ReplaceString(brushes(Str(id))\collision, " | " , Chr(13)+Chr(10), #PB_String_CaseSensitive))
    Else
      DisableGadget(#CollisionEditor, 1)
    EndIf
    Frame3DGadget(#InteractionFrame3D, #InteractionFrame3D_x, #InteractionFrame3D_y, #InteractionFrame3D_w, #InteractionFrame3D_h, "Interaction")
    EditorGadget(#InteractionEditor, #InteractionEditor_x, #InteractionEditor_y, #InteractionEditor_w, #InteractionEditor_h)
    If brushes(Str(id))\interaction <> ""
      SetGadgetText(#InteractionEditor, ReplaceString(brushes(Str(id))\interaction, " | " , Chr(13)+Chr(10), #PB_String_CaseSensitive))
    Else
      DisableGadget(#InteractionEditor, 1)
    EndIf
    ButtonGadget(#OKButton4, #OKButton4_x, #OKButton4_y, #OKButton4_w, #OKButton4_h, "Ok")
    ButtonGadget(#CancelButton4, #CancelButton4_x, #CancelButton4_y, #CancelButton4_w, #CancelButton4_h, "Cancel")

    Protected ok.l = 0, quit.l = 0, height.l, mask.l, collision.s, interaction.s
    DisableWindow(#Window, 1)
    Repeat
      Select WaitWindowEvent()
        Case #PB_Event_Gadget
          Select EventGadget()
            Case #NameString
              If GetGadgetState(#ComboBox) <> -1 And GetGadgetText(#NameString) <> ""
                DisableGadget(#OKButton4, 0)
              Else
                DisableGadget(#OKButton4, 1)
              EndIf
            Case #ComboBox
              If GetGadgetState(#ComboBox) <> -1 And GetGadgetText(#NameString) <> ""
                DisableGadget(#OKButton4, 0)
              Else
                DisableGadget(#OKButton4, 1)
              EndIf
            Case #InteractionCheckBox
              If GetGadgetState(#InteractionCheckBox) = #PB_Checkbox_Checked
                DisableGadget(#InteractionEditor, 0)
              Else
                DisableGadget(#InteractionEditor, 1)
              EndIf
            Case #CollisionCheckBox
              If GetGadgetState(#CollisionCheckBox) = #PB_Checkbox_Checked
                DisableGadget(#CollisionEditor, 0)
              Else
                DisableGadget(#CollisionEditor, 1)
              EndIf
            Case #TileTopCheckBox
              If GetGadgetState(#TileTopCheckBox) = #PB_Checkbox_Checked
                DisableGadget(#TileTopSpin, 0)
                DisableGadget(#ComboBox2, 0)
              Else
                DisableGadget(#TileTopSpin, 1)
                DisableGadget(#ComboBox2, 1)
              EndIf
            Case #AnimatedCheckBox
              If GetGadgetState(#AnimatedCheckBox) = #PB_Checkbox_Checked
                DisableGadget(#OffsetSpin, 0)
              Else
                DisableGadget(#OffsetSpin, 1)
              EndIf
            Case #OKButton4
              ok = 1
              quit = 1
            Case #CancelButton4
              ok = 0
              quit = 1
          EndSelect
        Default
          Delay(10)
      EndSelect
    Until quit
    If ok
      brushes(Str(id))\name = GetGadgetText(#NameString)
      brushes(Str(id))\tile = GetGadgetState(#ComboBox)
      brushes(Str(id))\animated = GetGadgetState(#AnimatedCheckBox)
      brushes(Str(id))\offset = GetGadgetState(#OffsetSpin)
      brushes(Str(id))\notpassable = GetGadgetState(#NotPassableCheckBox)
      If GetGadgetState(#TileTopCheckBox) = #PB_Checkbox_Checked
        brushes(Str(id))\height = GetGadgetState(#TileTopSpin)
        brushes(Str(id))\mask = GetGadgetState(#ComboBox2)
      Else
        brushes(Str(id))\height = 0
        brushes(Str(id))\mask = 0
      EndIf
      If GetGadgetState(#CollisionCheckBox) = #PB_Checkbox_Checked
        brushes(Str(id))\collision = ReplaceString(GetGadgetText(#CollisionEditor), Chr(13)+Chr(10), " | ", #PB_String_CaseSensitive)
      Else
        brushes(Str(id))\collision = ""
      EndIf
      If GetGadgetState(#InteractionCheckBox) = #PB_Checkbox_Checked
        brushes(Str(id))\interaction = ReplaceString(GetGadgetText(#InteractionEditor), Chr(13)+Chr(10), " | ", #PB_String_CaseSensitive)
      Else
        brushes(Str(id))\interaction = ""
      EndIf
      RefreshBrushes()
      SaveBrushes()
      HandleMap()
    EndIf
    SetGadgetState(#BrushesListIcon, selected_brush)
    CloseWindow(#Window_new_brush)
    DisableWindow(#Window, 0)
    SetActiveWindow(#Window)
  EndIf
EndProcedure

Procedure BrushGoto(id.l)
  If OpenWindow(#Window_brush_goto, 0, 0, #Window_brush_goto_w, #Window_brush_goto_h, "Goto...", #PB_Window_WindowCentered | #PB_Window_TitleBar, WindowID(#Window))
    Protected ok.l = 0, quit.l = 0
    SpinGadget(#GotoSpin, #GotoSpin_x, #GotoSpin_y, #GotoSpin_w, #GotoSpin_h, 0, CountGadgetItems(#BrushesListIcon)-1, #PB_Spin_Numeric)
    SetGadgetState(#GotoSpin, id)
    ButtonGadget(#OKButton5, #OKButton5_x, #OKButton5_y, #OKButton5_w, #OKButton5_h, "Ok")
    DisableGadget(#OKButton5, 1)
    ButtonGadget(#CancelButton5, #CancelButton5_x, #CancelButton5_y, #CancelButton5_w, #CancelButton5_h, "Cancel")
    DisableWindow(#Window, 1)
    Repeat
      Select WaitWindowEvent()
        Case #PB_Event_Gadget
          Select EventGadget()
            Case #GotoSpin
              Select EventType()
                Case #PB_EventType_Change
                  If GetGadgetState(#GotoSpin) <> -1 And GetGadgetState(#GotoSpin) >= 0 And GetGadgetState(#GotoSpin) <= CountGadgetItems(#BrushesListIcon)-1
                    DisableGadget(#OKButton5, 0)
                  Else
                    DisableGadget(#OKButton5, 1)
                  EndIf
              EndSelect
            Case #OKButton5
              ok = 1
              quit = 1
            Case #CancelButton5
              ok = 0
              quit = 1
          EndSelect
        Default
          Delay(10)
      EndSelect
    Until quit
    If ok
      SwapBrushes(id, GetGadgetState(#GotoSpin))
    EndIf
    CloseWindow(#Window_brush_goto)
    DisableWindow(#Window, 0)
    SetActiveWindow(#Window)
  EndIf
EndProcedure

Procedure SwapBrushes(id.l, newid.l)
  Swap brushes(Str(id))\name, brushes(Str(newid))\name
  Swap brushes(Str(id))\tile, brushes(Str(newid))\tile
  Swap brushes(Str(id))\animated, brushes(Str(newid))\animated
  Swap brushes(Str(id))\offset, brushes(Str(newid))\offset
  Swap brushes(Str(id))\notpassable, brushes(Str(newid))\notpassable
  Swap brushes(Str(id))\height, brushes(Str(newid))\height
  Swap brushes(Str(id))\mask, brushes(Str(newid))\mask
  Swap brushes(Str(id))\collision, brushes(Str(newid))\collision
  Swap brushes(Str(id))\interaction, brushes(Str(newid))\interaction
  RefreshBrushes()
  SaveBrushes()
  ReorganiseTilesID(id, newid)
  HandleMap()
  SetGadgetState(#BrushesListIcon, newid)
EndProcedure

Procedure SaveBrushes()
  RemovePreferenceGroup("brush")
  PreferenceGroup("brush")
  WritePreferenceLong("brushes", MapSize(brushes()))
  PreferenceComment("Brushes list")
  ForEach brushes()
    WritePreferenceString(MapKey(brushes())+".name", brushes()\name)
    WritePreferenceLong(MapKey(brushes())+".tile", brushes()\tile)
    WritePreferenceLong(MapKey(brushes())+".animated", brushes()\animated)
    WritePreferenceLong(MapKey(brushes())+".offset", brushes()\offset)
    WritePreferenceLong(MapKey(brushes())+".notpassable", brushes()\notpassable)
    WritePreferenceLong(MapKey(brushes())+".height", brushes()\height)
    WritePreferenceLong(MapKey(brushes())+".mask", brushes()\mask)
    WritePreferenceString(MapKey(brushes())+".collision", brushes()\collision)
    WritePreferenceString(MapKey(brushes())+".interaction", brushes()\interaction)
  Next
  ClosePreferences()
  OpenPreferences(#CONFIG_FILE)
EndProcedure

Procedure RefreshBrushes()
  ClearGadgetItems(#BrushesListIcon)
  ForEach brushes()
    LoadImage(Val(MapKey(brushes())), "tiles"+#Path_separator+tiles(Str(brushes()\tile)))
    AddGadgetItem(#BrushesListIcon, -1, Chr(10)+MapKey(brushes())+Chr(10)+brushes()\name+Chr(10)+tiles(Str(brushes()\tile))+Chr(10)+Str(brushes()\animated)+Chr(10)+Str(brushes()\offset)+Chr(10)+Str(brushes()\notpassable)+Chr(10)+Str(brushes()\height)+Chr(10)+Str(brushes()\mask)+Chr(10)+RemoveString(brushes()\collision, Chr(10))+Chr(10)+RemoveString(brushes()\interaction, Chr(10)), ImageID(Val(MapKey(brushes()))))
  Next
EndProcedure
; IDE Options = PureBasic 5.00 (Windows - x86)
; CursorPosition = 387
; FirstLine = 371
; Folding = --
; EnableXP
; UseMainFile = main.pb
; CurrentDirectory = ..\